Imports System.ComponentModel
Imports System.Drawing
Imports System.WinForms
Imports System.Runtime.InteropServices


'MODULE SECTION
Public Module mod1
    'declare delegate object
    Delegate Function HookCallback(ByVal Code As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
    
    'declare API's
    Public Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal HookID As Integer, ByVal lpfn As HookCallback, ByVal hModule As Integer, ByVal ThreadId As Integer) As Integer
    Public Declare Function UnhookWindowsHookEx Lib "user32" Alias "UnhookWindowsHookEx" (ByVal hHook As Integer) As Integer
    Public Declare Function CallNextHookEx Lib "user32" Alias "CallNextHookEx" (ByVal hHook As Integer, ByVal Code As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
    
    'Global constants    
    Public Const WH_KEYBOARD As Integer = 2
    
    'Global vars
    Public m_hHook As Integer
    
    'Property to access hook handle
    Property hHook() As Integer
        Set
            If m_hHook <> 0 And Value <> 0 Then
                'Don't overwrite the handle
                '   Unless it is being reset to 0
            Else
                m_hHook = Value
            End If
        End Set
        
        Get
            hHook = m_hHook
        End Get
    End Property
End Module


'FORM SECTION
Public Class Form1
    Inherits System.WinForms.Form
    
    'declare nested class var
    Public hk As Hook
    
    'declare delegate object
    Public cb As HookCallback
    
    
    
    'NESTED class containing the callback HookProc
    Public Class Hook
        'reference back to the form
        Private TheWin As Form1
        
        'ctor - used to get a reference to the main window
        '       in order to write info to the textbox1 text box
        Public Sub New(ByVal MainWnd As Form1)
            TheWin = MainWnd
        End Sub
        
        'HOOK PROC
        Public Function HookProc(ByVal Code As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
            TheWin.PrintTxt("Code: " & Code & "         wParam: " & wParam & "          lParam: " & lParam)
            HookProc = CallNextHookEx(hHook, Code, wParam, lParam)
        End Function
    End Class
    
    
    
    
    'START HERE - default ctor
    Public Sub New()
        MyBase.New()
        
        Form1 = Me
        
        'This call is required by the Win Form Designer.
        InitializeComponent()
        
        'instantiate a new nested Hook class
        '   passing in a reference to this form
        hk = New Hook(Me)
        
        'instantiate a new delegate object
        '   pointing to the HookProc function 
        '   in the nested class
        cb = New HookCallback(AddressOf hk.HookProc)
    End Sub
    
    'used by Form1 to add text to the textbox1 text box
    '   called by HookProc
    Public Sub PrintTxt(ByVal strOutput As String)
        txtOutput.Text = txtOutput.Text & strOutput & chr(13) & chr(10)
    End Sub
    
    'Form overrides dispose to clean up the component list.
    Public Overrides Sub Dispose()
        MyBase.Dispose()
        components.Dispose()
    End Sub
    
    'REGULAR WINDOWS .NET STUFF
#Region " Windows Form Designer generated code "
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents btnUnHook As System.WinForms.Button
    Private WithEvents btnHook As System.WinForms.Button
    Private WithEvents txtOutput As System.WinForms.TextBox
    
    Dim WithEvents Form1 As System.WinForms.Form
    
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.txtOutput = New System.WinForms.TextBox()
        Me.btnUnHook = New System.WinForms.Button()
        Me.btnHook = New System.WinForms.Button()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        txtOutput.Location = New System.Drawing.Point(88, 8)
        txtOutput.Multiline = True
        txtOutput.ScrollBars = System.WinForms.ScrollBars.Both
        txtOutput.TabIndex = 0
        txtOutput.Size = New System.Drawing.Size(400, 368)
        
        btnUnHook.Location = New System.Drawing.Point(8, 48)
        btnUnHook.Size = New System.Drawing.Size(75, 23)
        btnUnHook.TabIndex = 2
        btnUnHook.Text = "UnHook"
        
        btnHook.Location = New System.Drawing.Point(8, 8)
        btnHook.Size = New System.Drawing.Size(75, 23)
        btnHook.TabIndex = 1
        btnHook.Text = "Hook"
        Me.Text = "VB.NET Hooking Example"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(496, 381)
        
        Me.Controls.Add(btnUnHook)
        Me.Controls.Add(btnHook)
        Me.Controls.Add(txtOutput)
    End Sub
#End Region
    
    Protected Sub btnUnHook_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        msgbox("UnhookWindowsHookEx returned: " & UnhookWindowsHookEx(hHook))
        hHook = 0
    End Sub
    
    Protected Sub btnHook_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        hHook = SetWindowsHookEx(WH_KEYBOARD, cb, 0, appdomain.GetCurrentThreadId)
        msgbox("SetWindowsHookEx returned: " & hHook)
    End Sub
End Class

